package com.waytous.anticollision.ui.view

import android.content.Context
import android.content.Intent
import android.view.Gravity
import android.view.View
import android.view.View.OnClickListener
import androidx.appcompat.widget.AppCompatTextView
import com.waytous.anticollision.R
import com.waytous.anticollision.ui.collect.CollectActivity
import com.waytous.anticollision.ui.health.HealthManagerActivity
import com.waytous.anticollision.ui.settings.UserSettingsActivity
import com.waytous.anticollision.ui.statistics.DataStatisticsActivity
import razerdp.basepopup.BasePopupWindow
import javax.inject.Inject

class ButtonMorePopup @Inject constructor(context: Context) : BasePopupWindow(context),OnClickListener{

    init {
        contentView = createPopupById(R.layout.popup_more_features)
        setOutSideDismiss(true)
        popupGravity = Gravity.TOP or Gravity.CENTER
        setBackgroundColor(R.color.color_99000000)
        contentView.findViewById<AppCompatTextView>(R.id.featureCollect).setOnClickListener(this)
        contentView.findViewById<AppCompatTextView>(R.id.featureHealth).setOnClickListener(this)
        contentView.findViewById<AppCompatTextView>(R.id.featureData).setOnClickListener(this)
        contentView.findViewById<AppCompatTextView>(R.id.featureSettings).setOnClickListener(this)
        contentView.findViewById<AppCompatTextView>(R.id.featureReboot).setOnClickListener(this)
        contentView.findViewById<AppCompatTextView>(R.id.featurePowerOff).setOnClickListener(this)
    }


    override fun onClick(v: View?) {
        dismiss()
        when(v?.id){
            R.id.featureCollect->{
                context.startActivity(Intent(context,CollectActivity::class.java))
            }
            R.id.featureHealth->{
                context.startActivity(Intent(context,HealthManagerActivity::class.java))
            }
            R.id.featureData->{
                context.startActivity(Intent(context,DataStatisticsActivity::class.java))
            }
            R.id.featureSettings->{
                context.startActivity(Intent(context,UserSettingsActivity::class.java))
            }
            R.id.featureReboot->{

            }
            R.id.featurePowerOff->{

            }
        }
    }
}