package com.waytous.anticollision.ui.view

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.WindowManager
import android.widget.RadioGroup
import android.widget.RadioGroup.OnCheckedChangeListener
import androidx.core.view.WindowCompat
import androidx.core.view.WindowInsetsCompat
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.KeyboardUtils
import com.blankj.utilcode.util.LogUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.DialogDelayCauseSelectBinding

class DelayCauseDialog(context: Context, themeResId: Int) : Dialog(context, themeResId) {

    private lateinit var binding:DialogDelayCauseSelectBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window?.let { BarUtils.setNavBarVisibility(it,false) }
        window?.setLayout(context.resources.getDimension(R.dimen.dp_984).toInt(),context.resources.getDimension(R.dimen.dp_636).toInt())
        val inflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.dialog_delay_cause_select,null)
        }
        binding = DialogDelayCauseSelectBinding.inflate(inflater)
        KeyboardUtils.toggleSoftInput()
        setContentView(binding.root)
        binding.radioGroup1.setOnCheckedChangeListener(DelaySelectItemCheckedListener())
        binding.radioGroup2.setOnCheckedChangeListener(DelaySelectItemCheckedListener())
        binding.radioGroup3.setOnCheckedChangeListener(DelaySelectItemCheckedListener())
        binding.delayCauseConfirm.setOnClickListener {  }
        binding.delayCauseCancel.setOnClickListener {
            dismiss()
            window?.let { BarUtils.setNavBarVisibility(it,false) }
        }
        binding.delayCauseSelectClose.setOnClickListener {
            dismiss()
            window?.let { BarUtils.setNavBarVisibility(it,false) }
        }
    }

    override fun show() {
        window?.setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE)
        super.show()
        val controller = window?.let {  WindowCompat.getInsetsController(it,it.decorView) }
        controller?.hide(WindowInsetsCompat.Type.systemBars())
        window?.clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE)
    }

    inner class DelaySelectItemCheckedListener:OnCheckedChangeListener{
        override fun onCheckedChanged(group: RadioGroup?, checkedId: Int) {
            when(group?.id){
                R.id.radioGroup1 ->{
                    binding.radioGroup2.setOnCheckedChangeListener(null)
                    binding.radioGroup2.clearCheck()
                    binding.radioGroup3.setOnCheckedChangeListener(null)
                    binding.radioGroup3.clearCheck()
                    when(checkedId){
                        R.id.itemShiftsChange->{
                            LogUtils.d("交接班")
                        }
                        R.id.itemStandbyPark->{
                            LogUtils.d("备停")
                        }
                        R.id.itemWeatherEffect->{
                            LogUtils.d("天气影响")
                        }
                        R.id.itemExternalReasons->{
                            LogUtils.d("外界原因")
                        }
                    }
                    binding.radioGroup2.setOnCheckedChangeListener(this)
                    binding.radioGroup3.setOnCheckedChangeListener(this)
                }
                R.id.radioGroup2 ->{
                    binding.radioGroup1.setOnCheckedChangeListener(null)
                    binding.radioGroup1.clearCheck()
                    binding.radioGroup3.setOnCheckedChangeListener(null)
                    binding.radioGroup3.clearCheck()
                    when(checkedId){
                        R.id.itemFaultOutage->{
                            LogUtils.d("故障停电")
                        }
                        R.id.itemShoveling->{
                            LogUtils.d("待铲")
                        }
                        R.id.itemScheduledOutage->{
                            LogUtils.d("计划停电")
                        }
                        R.id.itemBlastingImpact->{
                            LogUtils.d("爆破影响")
                        }
                    }
                    binding.radioGroup1.setOnCheckedChangeListener(this)
                    binding.radioGroup3.setOnCheckedChangeListener(this)
                }
                R.id.radioGroup3 ->{
                    binding.radioGroup1.setOnCheckedChangeListener(null)
                    binding.radioGroup1.clearCheck()
                    binding.radioGroup2.setOnCheckedChangeListener(null)
                    binding.radioGroup2.clearCheck()
                    when(checkedId){
                        R.id.itemOtherInput->{
                            LogUtils.d("其他录入")
                        }
                    }
                    binding.radioGroup1.setOnCheckedChangeListener(this)
                    binding.radioGroup2.setOnCheckedChangeListener(this)
                }
            }
        }

    }
}