package com.waytous.anticollision.ui.view

import android.app.Dialog
import android.content.Context
import android.view.Gravity
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.PopupReportStatusBinding
import razerdp.basepopup.BasePopupWindow
import javax.inject.Inject

class ButtonReportStatusPopup @Inject constructor(context: Context?,val binding: PopupReportStatusBinding) : BasePopupWindow(context) {

    init {
        contentView = binding.root
        setOutSideDismiss(true)
        popupGravity = Gravity.TOP or Gravity.CENTER
        setBackgroundColor(R.color.color_99000000)
    }

    fun itemDumping(){

    }

    fun itemDelay(dialog:Dialog){
        binding.reportDialogDelay.setOnClickListener {
            dialog.show()
        }
    }

    fun itemFault(dialog: Dialog){
        binding.reportDialogFault.setOnClickListener {
            dialog.show()
        }
    }

    fun itemStandby(dialog: Dialog){
        binding.reportDialogStandby.setOnClickListener {
            dialog.show()
        }
    }
}