package com.waytous.anticollision.ui.collect

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.AdapterView.OnItemSelectedListener
import androidx.fragment.app.Fragment
import androidx.navigation.fragment.findNavController
import com.blankj.utilcode.util.LogUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentCollectBinding
import com.waytous.anticollision.databinding.LayoutMapBoxBinding
import com.waytous.anticollision.databinding.RadioTabCollectBinding
import com.waytous.anticollision.databinding.RadioTabSettingsBinding
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class CollectFragment : Fragment() {

    private var _binding: FragmentCollectBinding? = null

    @Inject
    lateinit var mapBoxBinding: LayoutMapBoxBinding
    @Inject
    lateinit var tabCollectBinding: RadioTabCollectBinding
    @Inject
    lateinit var tabSettingsBinding: RadioTabSettingsBinding

    private val itemSelectedListener by lazy {
        object:OnItemSelectedListener{
            override fun onItemSelected(
                parent: AdapterView<*>?,
                view: View?,
                position: Int,
                id: Long
            ) {
                LogUtils.d("selected position = $position")
                iconCalibrates.filterIndexed { index, appCompatImageView ->
                    LogUtils.d("filterIndexed index = $index")
                    appCompatImageView.setImageResource(R.drawable.icon_vehicle_uncalibrated)
                    index == position
                }.forEach {
                    it.setImageResource(R.drawable.icon_vehicle_calibrate)
                }
            }

            override fun onNothingSelected(parent: AdapterView<*>?) {

            }

        }
    }
    private val binding get() = _binding!!

    private val iconCalibrates by lazy {
        listOf(tabCollectBinding.vehicleLeftFrontWheel,
            tabCollectBinding.vehicleRightFrontWheel,
            tabCollectBinding.vehicleLeftBackWheel,
            tabCollectBinding.vehicleRightBackWheel,
            tabCollectBinding.vehicleGeometricCenter,
            tabCollectBinding.vehicleFrontAxleCenter,
            tabCollectBinding.vehicleBackAxleCenter)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentCollectBinding.inflate(inflater, container, false)
        context?:return binding.root
        binding.collectMapWrapper.addView(mapBoxBinding.root)
        initTabLayout()
        binding.collectTabBtnToHome.setOnClickListener {
            findNavController().navigate(R.id.navigation_home)
        }
        return binding.root
    }

    private fun initTabLayout(){
        binding.collectTabContent.addView(tabCollectBinding.root)
        tabCollectBinding.collectSpinnerVehicleParts.onItemSelectedListener = itemSelectedListener
        binding.collectRadioGroup.setOnCheckedChangeListener { _, checkedId ->
            binding.collectTabContent.removeAllViews()
            if (checkedId == R.id.collectTabCollect) {
                binding.collectTabContent.addView(tabCollectBinding.root)
            } else {
                binding.collectTabContent.addView(tabSettingsBinding.root)
            }
        }
    }

}