package com.waytous.anticollision.ui

import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mapbox.geojson.Point
import com.waytous.anticollision.bean.MapDataSource
import com.waytous.anticollision.repository.MainRepository
import com.waytous.anticollision.utils.LATITUDE
import com.waytous.anticollision.utils.LONGITUDE
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.flattenMerge
import kotlinx.coroutines.flow.flowOf
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch
import java.math.BigDecimal
import javax.inject.Inject

@HiltViewModel
class MainModel @Inject constructor(private val mainRepository: MainRepository) : ViewModel() {

    val zoom: MutableLiveData<BigDecimal> by lazy {
        MutableLiveData(BigDecimal(16.0))
    }

    val center: MutableLiveData<Point> by lazy {
        MutableLiveData(Point.fromLngLat(LONGITUDE, LATITUDE))
    }

    private val _obstaclesSource = MutableStateFlow(MapDataSource())

    private val _electronicFence = MutableStateFlow(MapDataSource())

    private val _wetArea = MutableStateFlow(MapDataSource())

    private val _laneNode = MutableStateFlow(MapDataSource())

    private val _lane = MutableStateFlow(MapDataSource())

    private val _runnableArea = MutableStateFlow(MapDataSource())

    private val _dumpArea = MutableStateFlow(MapDataSource())

    private val _diggingWorkArea = MutableStateFlow(MapDataSource())

    private val _barricade = MutableStateFlow(MapDataSource())

    private val _stationArea = MutableStateFlow(MapDataSource())

    private val _parkSpot = MutableStateFlow(MapDataSource())

    private val _staticObjects = MutableStateFlow(MapDataSource())

    init {
        viewModelScope.launch {
            mainRepository.remoteObstaclesVersion().collect{
                if (_obstaclesSource.value.version != it.version) {
                    _obstaclesSource.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteElectronicFenceVersion().collect{
                if (_electronicFence.value.version != it.version) {
                    _electronicFence.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteWetAreaVersion().collect{
                if (_wetArea.value.version != it.version) {
                    _wetArea.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteLaneNodeVersion().collect{
                if (_laneNode.value.version != it.version) {
                    _laneNode.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteLaneVersion().collect{
                if (_lane.value.version != it.version) {
                    _lane.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteRunnableAreaVersion().collect{
                if (_runnableArea.value.version != it.version) {
                    _runnableArea.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteDumpAreaVersion().collect{
                if (_dumpArea.value.version != it.version) {
                    _dumpArea.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteDiggingWorkAreaVersion().collect{
                if (_diggingWorkArea.value.version != it.version) {
                    _diggingWorkArea.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteBarricadeVersion().collect{
                if (_barricade.value.version != it.version) {
                    _barricade.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteStationAreaVersion().collect{
                if (_stationArea.value.version != it.version) {
                    _stationArea.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteParkSpotVersion().collect{
                if (_parkSpot.value.version != it.version) {
                    _parkSpot.value  = it
                }
            }
        }
        viewModelScope.launch {
            mainRepository.remoteStaticObjectsVersion().collect{
                if (_staticObjects.value.version != it.version) {
                    _staticObjects.value  = it
                }
            }
        }
    }
    @OptIn(ExperimentalCoroutinesApi::class)
    suspend fun loadMapDataSource() = flowOf(
        _obstaclesSource,
        _electronicFence,
        _wetArea,
        _laneNode,
        _lane,
        _runnableArea,
        _dumpArea,
        _diggingWorkArea,
        _barricade,
        _stationArea,
        _parkSpot,
        _staticObjects
    ).flattenMerge().stateIn(viewModelScope)

}