package com.waytous.anticollision.ui

import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ScreenUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.ActivitySplashBinding
import com.waytous.anticollision.ui.home.HomeActivity

class SplashActivity : AppCompatActivity() {

    private lateinit var binding:ActivitySplashBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ScreenUtils.setFullScreen(this)
        BarUtils.setNavBarVisibility(this,false)
        binding = ActivitySplashBinding.inflate(layoutInflater)
        setContentView(binding.root)
        "${getString(R.string.text_progress, 57)}%".also { binding.textProgress.text = it }
        binding.loadingProgressBar.progress = 57
        binding.loadingProgressBar.show()
        binding.loadingProgressBar.postDelayed({
                         startActivity(Intent(this, HomeActivity::class.java))
        },2000)
    }



}