package com.waytous.anticollision.utils

import java.util.concurrent.ThreadFactory
import java.util.concurrent.atomic.AtomicInteger

/**
 * 现场创建工厂
 * @param prefix
 * */
class NamedThreadFactory(private val prefix: String) : ThreadFactory {

    private val threadNumber by lazy {
        AtomicInteger(1)
    }

    override fun newThread(r: Runnable?): Thread = Thread(
        null,
        r,
        if (prefix == "Receive" || prefix == "Parser") prefix else "$prefix-${threadNumber.getAndIncrement()}"
    )
}