package com.waytous.anticollision.config

import com.blankj.utilcode.util.DeviceUtils
import com.waytous.anticollision.utils.PreferenceDelegate
import io.github.toggery.jt808.messagebody.B0100

/**
 * 设备配置参数
 * */
object DeviceConfig {

    /**
     * 省份ID
     * */
    var province: Int by PreferenceDelegate("province", 11)

    /**
     * 城市ID
     * */
    var city: Int by PreferenceDelegate("city", 0)

    /**
     * 车牌颜色
     * */
    var plateColor: Int by PreferenceDelegate("plateColor", B0100.PLATE_COLOR_YELLOW)

    /**
     * 设备制造商
     * */
    var maker: String by PreferenceDelegate("maker", DeviceUtils.getManufacturer())

    /**
     * 手机号码
     * */
    var phoneNumber: String by PreferenceDelegate("phone", "")



    object HostConfig {
        /**
         * 服务器地址
         * */
        var host: String by PreferenceDelegate("host", "")

        /**
         * 服务器端口
         * */
        var port: Int by PreferenceDelegate("port", 0)
    }
}