package com.waytous.anticollision

import android.app.Application
import com.blankj.utilcode.util.LogUtils
import com.blankj.utilcode.util.SPStaticUtils
import com.blankj.utilcode.util.SPUtils
import com.blankj.utilcode.util.Utils
import dagger.hilt.android.HiltAndroidApp
import kotlin.properties.Delegates

@HiltAndroidApp
class AntiCollisionApp: Application(){

    override fun onCreate() {
        super.onCreate()
        Utils.init(this)
        LogUtils.getConfig().globalTag = "Waytous"
        SPStaticUtils.setDefaultSPUtils(SPUtils.getInstance("settings"))
    }

    companion object {
        //情况一：声明可空的属性
        private var instance: AntiCollisionApp by Delegates.notNull()
        fun instance() = instance
    }
}