package com.waytous.anticollision.ui.view

import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.widget.RadioGroup
import android.widget.RadioGroup.OnCheckedChangeListener
import androidx.appcompat.app.AlertDialog
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.LogUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.DialogFaultCauseSelectBinding

class FaultCauseDialog(context: Context, themeResId: Int) : AlertDialog(context, themeResId) {

    private lateinit var binding:DialogFaultCauseSelectBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window?.let { BarUtils.setNavBarVisibility(it,false) }
        window?.setLayout(context.resources.getDimension(R.dimen.dp_984).toInt(),context.resources.getDimension(R.dimen.dp_636).toInt())
        val inflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.dialog_fault_cause_select,null)
        }
        binding = DialogFaultCauseSelectBinding.inflate(inflater)
        setContentView(binding.root)
        binding.radioGroup1.setOnCheckedChangeListener(FaultCauseItemCheckedListener())
        binding.radioGroup2.setOnCheckedChangeListener(FaultCauseItemCheckedListener())
        binding.faultCauseConfirm.setOnClickListener {  }
        binding.faultCauseCancel.setOnClickListener {
            dismiss()
        }
        binding.faultCauseSelectClose.setOnClickListener {
            dismiss()
        }
    }

    inner class FaultCauseItemCheckedListener:OnCheckedChangeListener{
        override fun onCheckedChanged(group: RadioGroup?, checkedId: Int) {
            when(group?.id){
                R.id.radioGroup1 ->{
                    binding.radioGroup2.setOnCheckedChangeListener(null)
                    binding.radioGroup2.clearCheck()
                    when(checkedId){
                        R.id.itemFaultEngine->{
                            LogUtils.d("发动机故障")
                        }
                        R.id.itemFaultMechanical->{
                            LogUtils.d("机械故障")
                        }
                        R.id.itemFaultHydraulicSystem->{
                            LogUtils.d("液压系统故障")
                        }
                        R.id.itemFaultElectrical->{
                            LogUtils.d("电气系统故障")
                        }
                    }
                    binding.radioGroup2.setOnCheckedChangeListener(this)
                }
                R.id.radioGroup2 ->{
                    binding.radioGroup1.setOnCheckedChangeListener(null)
                    binding.radioGroup1.clearCheck()
                    when(checkedId){
                        R.id.itemFaultEdgeReduction->{
                            LogUtils.d("边减故障")
                        }
                        R.id.itemFaultTire->{
                            LogUtils.d("轮胎故障")
                        }
                        R.id.itemFaultEquipmentMaintenance->{
                            LogUtils.d("设备保养")
                        }
                        R.id.itemFaultOtherInputs->{
                            LogUtils.d("其他录入")
                        }
                    }
                    binding.radioGroup1.setOnCheckedChangeListener(this)
                }
            }
        }

    }
}