package com.waytous.anticollision.ui.settings

import android.os.Bundle
import android.view.View
import android.view.View.OnClickListener
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ScreenUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.ActivityUserSettingsBinding
import com.waytous.anticollision.databinding.FixedInfoLayoutBinding
import com.waytous.anticollision.databinding.NetworkSettingsLayoutBinding
import com.waytous.anticollision.databinding.VehicleInfoLayoutBinding
import com.waytous.anticollision.ui.view.ButtonMorePopup
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class UserSettingsActivity : AppCompatActivity(),OnClickListener{

    lateinit var binding: ActivityUserSettingsBinding

    @Inject
    lateinit var vehicleInfoBinding: VehicleInfoLayoutBinding

    @Inject
    lateinit var netSettingsBinding: NetworkSettingsLayoutBinding

    @Inject
    lateinit var fixedInfoBinding: FixedInfoLayoutBinding

    lateinit var popupMoreFeatures: ButtonMorePopup

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ScreenUtils.setFullScreen(this)
        BarUtils.setNavBarVisibility(this, false)
        binding = ActivityUserSettingsBinding.inflate(layoutInflater)
        setContentView(binding.root)
        initTabLayout()
        popupMoreFeatures = ButtonMorePopup(this).also {
            it.bindLifecycleOwner(this)
        }
        binding.more.setOnClickListener(this)
        binding.goHome.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when(v){
            binding.more -> popupMoreFeatures.showPopupWindow(binding.more)
            binding.goHome -> finish()
        }
    }

    private fun initTabLayout() {
        binding.tabContent.addView(vehicleInfoBinding.root)
        binding.tabContent.setPadding(resources.getDimension(R.dimen.dp_26).toInt(),0,0,0)
        binding.tabContainer.setOnCheckedChangeListener { _, checkedId ->
            binding.tabContent.removeAllViews()
            when (checkedId) {
                R.id.tabVehicleInfo -> {
                    binding.tabContent.setPadding(resources.getDimension(R.dimen.dp_26).toInt(),0,0,0)
                    binding.tabContent.addView(vehicleInfoBinding.root)
                }

                R.id.tabNetwork -> {
                    binding.tabContent.setPadding(resources.getDimension(R.dimen.dp_39).toInt(),0,0,0)
                    binding.tabContent.addView(netSettingsBinding.root)
                }

                R.id.tabFixedInfo -> {
                    binding.tabContent.setPadding(resources.getDimension(R.dimen.dp_26).toInt(),0,0,0)
                    binding.tabContent.addView(fixedInfoBinding.root)
                }
            }
        }
    }
}