package com.waytous.anticollision.ui.collect

import android.os.Bundle
import android.view.View
import android.view.View.OnClickListener
import android.widget.AdapterView
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.LogUtils
import com.blankj.utilcode.util.ScreenUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.ActivityCollectBinding
import com.waytous.anticollision.databinding.RadioTabCollectBinding
import com.waytous.anticollision.databinding.RadioTabSettingsBinding
import com.waytous.anticollision.ui.MainViewModel
import com.waytous.anticollision.ui.view.ButtonMorePopup
import com.waytous.anticollision.utils.setupMapBox
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class CollectActivity : AppCompatActivity(),OnClickListener {

    lateinit var binding:ActivityCollectBinding

    @Inject
    lateinit var mainViewModel: MainViewModel

    @Inject
    lateinit var tabCollectBinding: RadioTabCollectBinding
    @Inject
    lateinit var tabSettingsBinding: RadioTabSettingsBinding

    lateinit var popupMoreFeatures: ButtonMorePopup

    private val itemSelectedListener by lazy {
        object: AdapterView.OnItemSelectedListener {
            override fun onItemSelected(
                parent: AdapterView<*>?,
                view: View?,
                position: Int,
                id: Long
            ) {
                LogUtils.d("selected position = $position")
                iconCalibrates.filterIndexed { index, appCompatImageView ->
                    LogUtils.d("filterIndexed index = $index")
                    appCompatImageView.setImageResource(R.drawable.icon_vehicle_uncalibrated)
                    index == position
                }.forEach {
                    it.setImageResource(R.drawable.icon_vehicle_calibrate)
                }
            }

            override fun onNothingSelected(parent: AdapterView<*>?) {

            }

        }
    }

    private val iconCalibrates by lazy {
        listOf(tabCollectBinding.vehicleLeftFrontWheel,
            tabCollectBinding.vehicleRightFrontWheel,
            tabCollectBinding.vehicleLeftBackWheel,
            tabCollectBinding.vehicleRightBackWheel,
            tabCollectBinding.vehicleGeometricCenter,
            tabCollectBinding.vehicleFrontAxleCenter,
            tabCollectBinding.vehicleBackAxleCenter)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ScreenUtils.setFullScreen(this)
        BarUtils.setNavBarVisibility(this,false)
        binding = ActivityCollectBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.titleBar.statusBarDriverInfo.visibility = View.VISIBLE
        initTabLayout()
        setupMapBox(binding.mapContainer,mainViewModel)
        popupMoreFeatures = ButtonMorePopup(this).also {
            it.bindLifecycleOwner(this)
        }
        binding.more.setOnClickListener(this)
        binding.goHome.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when(v){
            binding.more -> popupMoreFeatures.showPopupWindow(binding.more)
            binding.goHome -> finish()
        }
    }
    private fun initTabLayout(){
        binding.tabContent.addView(tabCollectBinding.root)
        tabCollectBinding.collectSpinnerVehicleParts.onItemSelectedListener = itemSelectedListener
        binding.tabContainer.setOnCheckedChangeListener { _, checkedId ->
            binding.tabContent.removeAllViews()
            if (checkedId == R.id.tabCollect) {
                binding.tabContent.addView(tabCollectBinding.root)
            } else {
                binding.tabContent.addView(tabSettingsBinding.root)
            }
        }
    }

}