package com.waytous.anticollision.ui.collect

import android.app.Dialog
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.navigation.fragment.findNavController
import com.afollestad.materialdialogs.MaterialDialog
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentCollectBinding

class CollectFragment : Fragment() {

    companion object{
        const val TAB_ITEM_COLLECT  = 0x01
        const val TAB_ITEM_SETTINGS = 0x02
    }

    private var _binding: FragmentCollectBinding? = null
    private val binding get() = _binding!!

    private lateinit var dialogFaultCause:Dialog

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentCollectBinding.inflate(inflater, container, false)
        context?:return binding.root
        initTabLayout()
        dialogFaultCause = Dialog(requireContext()).also {
            it.setContentView(R.layout.dialog_fault_cause_select)
        }
        binding.collectTabBtnToHome.setOnClickListener {
            findNavController().navigate(R.id.navigation_home)
        }
        return binding.root
    }

    private fun initTabLayout(){
        val collectItem = LayoutInflater.from(context).inflate(
            R.layout.fragment_collect_tab_collect,
            null,
            false
        )
        binding.collectTabContent.addView(collectItem)
        val settingsItem = LayoutInflater.from(context).inflate(
            R.layout.fragment_collect_tab_settings,
            null,
            false
        )
        binding.collectRadioGroup.setOnCheckedChangeListener { _, checkedId ->
            binding.collectTabContent.removeAllViews()
            if (checkedId == R.id.collectTabCollect) {
                binding.collectTabContent.addView(collectItem)
            } else {
                binding.collectTabContent.addView(settingsItem)
            }
        }
    }

}