package com.waytous.anticollision.utils

import java.util.concurrent.ThreadFactory
import java.util.concurrent.atomic.AtomicInteger

/**
 * 现场创建工厂
 * @param prefix
 * */
class NamedThreadFactory(private val prefix: String, private val ignoreThreadNumber:Boolean = true) : ThreadFactory {

    private val threadNumber by lazy {
        AtomicInteger(1)
    }

    override fun newThread(r: Runnable?): Thread = Thread(
        null,
        r,
        if (ignoreThreadNumber) prefix else "$prefix-${threadNumber.getAndIncrement()}"
    )
}