package com.waytous.anticollision.ui.video

import android.os.Bundle
import android.text.SpannableString
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.BindingAdapter
import androidx.databinding.adapters.VideoViewBindingAdapter
import androidx.fragment.app.Fragment
import androidx.fragment.app.viewModels
import com.mapbox.maps.MapView
import com.mapbox.maps.MapboxMap
import com.mapbox.maps.plugin.locationcomponent.location
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentVideoHomeBinding
import com.waytous.anticollision.utils.setTextSize

class VideoHomeFragment : Fragment() {

    private lateinit var binding:FragmentVideoHomeBinding

    private lateinit var mapView:MapView

    companion object {
        fun newInstance() = VideoHomeFragment()
    }

    private val viewModel: VideoHomeViewModel by viewModels()

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = FragmentVideoHomeBinding.inflate(inflater, container, false)
        context?:return binding.root
        val templateString = getString(R.string.current_speed,36)
        val spannableString = SpannableString(templateString)
        binding.speedText.setTextSize(spannableString,templateString)
        mapView = binding.root.findViewById(R.id.mapView)
        return binding.root
    }

}