package com.waytous.anticollision.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.fragment.NavHostFragment
import androidx.navigation.ui.setupWithNavController
import com.google.android.material.bottomnavigation.BottomNavigationView
import com.gyf.immersionbar.ImmersionBar
import com.waytous.anticollision.R
import com.waytous.anticollision.config.DeviceConfig
import com.waytous.anticollision.databinding.ActivityMainBinding
import com.waytous.anticollision.tcp.Session
import kotlin.concurrent.thread

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        supportActionBar?.hide()
        ImmersionBar.with(this)
            .statusBarAlpha(0.0f)
            .statusBarDarkFont(true)
            .fitsSystemWindows(true)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        DeviceConfig.province = 11
        DeviceConfig.city = 0
        DeviceConfig.phoneNumber = "18801022222"

        DeviceConfig.HostConfig.host = "47.100.112.218"
        DeviceConfig.HostConfig.port = 8808
        val session = Session()
        thread { session.login() }
    }

}