package com.waytous.anticollision.config

import com.blankj.utilcode.util.SPUtils

/**
 * 设置
 * */
object Settings {

    /**
     * 司机姓名
     * */
    var driverName: String = ""
        @Synchronized set

    /**
     * 车牌号
     * */
    var plateNo: String = ""
        @Synchronized set

    /**
     * 设备唯一识别码
     * */
    var deviceId: String = SPUtils.getInstance().getString("deviceId", "")

    /**
     * 是否已注册
     * */
    var isRegistered: Boolean = SPUtils.getInstance().getBoolean("isRegistered", false)

    /**
     * 设备注册鉴权码
     * */
    var token: String = SPUtils.getInstance().getString("token", "")

    /**
     * DWORD 终端心跳发送间隔，单位为秒（s）,默认2分钟
     * */
    var x0001:Long = SPUtils.getInstance().getLong("x0001", 120)
    /**
     * DWORD 消息应答超时时间，单位为秒（s）
     * */
    var x0002:Long = SPUtils.getInstance().getLong("x0002", 60)
    /**
     * DWORD TCP 消息重传次数
     * */
    var x0003:Long = SPUtils.getInstance().getLong("x0003", 3)
    /**
     * STRING 主服务器 APN，无线通信拨号访问点，若网络制式为 CDMA，则该处为 PPP 拨号号码
     * */
    var x0010:String = SPUtils.getInstance().getString("x0010", "")
    /**
     * STRING 主服务器无线通信拨号用户名
     * */
    var x0011:String = SPUtils.getInstance().getString("x0011", "")
    /**
     * STRING 主服务器无线通信拨号密码
     * */
    var x0012:String = SPUtils.getInstance().getString("x0012", "")
    /**
     * STRING 主服务器地址，IP 或域名(2019 版以冒号分割主机和端口，多个服务器使用分号分隔)
     * */
    var x0013:String = SPUtils.getInstance().getString("x0013", "")
    /**
     * STRING 备份服务器 APN，无线通信拨号访问点
     * */
    var x0014:String = SPUtils.getInstance().getString("x0014", "")
    /**
     * STRING 备份服务器无线通信拨号用户名
     * */
    var x0015:String = SPUtils.getInstance().getString("x0015", "")
    /**
     * STRING 备份服务器无线通信拨号密码
     * */
    var x0016:String = SPUtils.getInstance().getString("x0016", "")
    /**
     * STRING 备份服务器地址、IP 或域名(2019 版以冒号分割主机和端口，多个服务器使用分号分隔)
     * */
    var x0017:String = SPUtils.getInstance().getString("x0017", "")
    /**
     * DWORD 服务器 TCP 端口 // 2019 del
     * */
    var x0018:Long = SPUtils.getInstance().getLong("x0018", -1)
    /**
     * STRING 道路运输证 IC 卡认证主服务器 IP 地址或域名
     * */
    var x001A:String = SPUtils.getInstance().getString("x001A", "")
    /**
     * DWORD 道路运输证 IC 卡认证主服务器 TCP 端口
     * */
    var x001B:Long = SPUtils.getInstance().getLong("x001B", -1)

}