package com.waytous.anticollision.ui.collect

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.AdapterView.OnItemSelectedListener
import androidx.appcompat.widget.AppCompatImageView
import androidx.navigation.fragment.findNavController
import com.blankj.utilcode.util.LogUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentCollectBinding
import com.waytous.anticollision.databinding.FragmentCollectTabCollectBinding
import com.waytous.anticollision.databinding.FragmentCollectTabSettingsBinding
import com.waytous.anticollision.ui.BaseMapFragment

class CollectFragment : BaseMapFragment() {

    companion object{
        const val TAB_ITEM_COLLECT  = 0x01
        const val TAB_ITEM_SETTINGS = 0x02
    }

    private var _binding: FragmentCollectBinding? = null

    private lateinit var tabCollectBinding: FragmentCollectTabCollectBinding

    private lateinit var tabSettingsBinding: FragmentCollectTabSettingsBinding
    private val binding get() = _binding!!

    private val iconCalibrates by lazy {
        listOf(tabCollectBinding.vehicleLeftFrontWheel,
            tabCollectBinding.vehicleRightFrontWheel,
            tabCollectBinding.vehicleLeftBackWheel,
            tabCollectBinding.vehicleRightBackWheel,
            tabCollectBinding.vehicleGeometricCenter,
            tabCollectBinding.vehicleFrontAxleCenter,
            tabCollectBinding.vehicleBackAxleCenter)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentCollectBinding.inflate(inflater, container, false)
        context?:return binding.root
        setupMapBox()
        binding.collectMapWrapper.addView(layoutMapBoxBinding.root)
        tabCollectBinding = FragmentCollectTabCollectBinding.bind(LayoutInflater.from(context).inflate(
            R.layout.fragment_collect_tab_collect,
            null,
            false
        )).apply {
            collectSpinnerVehicleParts.onItemSelectedListener = object:OnItemSelectedListener{
                override fun onItemSelected(
                    parent: AdapterView<*>?,
                    view: View?,
                    position: Int,
                    id: Long
                ) {
                    LogUtils.d("selected position = $position")
                    iconCalibrates.filterIndexed { index, appCompatImageView ->
                        LogUtils.d("filterIndexed index = $index")
                        appCompatImageView.setImageResource(R.drawable.icon_vehicle_uncalibrated)
                        index == position
                    }.forEach {
                        it.setImageResource(R.drawable.icon_vehicle_calibrate)
                    }
                }

                override fun onNothingSelected(parent: AdapterView<*>?) {

                }

            }
        }
        tabSettingsBinding = FragmentCollectTabSettingsBinding.bind(LayoutInflater.from(context).inflate(
            R.layout.fragment_collect_tab_settings,
            null,
            false
        ))
        initTabLayout()
        binding.collectTabBtnToHome.setOnClickListener {
            findNavController().navigate(R.id.navigation_home)
        }
        return binding.root
    }

    private fun initTabLayout(){
        binding.collectTabContent.addView(tabCollectBinding.root)
        binding.collectRadioGroup.setOnCheckedChangeListener { _, checkedId ->
            binding.collectTabContent.removeAllViews()
            if (checkedId == R.id.collectTabCollect) {
                binding.collectTabContent.addView(tabCollectBinding.root)
            } else {
                binding.collectTabContent.addView(tabSettingsBinding.root)
            }
        }
    }

}