package com.waytous.anticollision.listener

import com.waytous.anticollision.tcp.Error
import com.waytous.anticollision.utils.ConnectStatus

interface SessionListener {

    /**
     * 连接状态发生变化
     * */
    fun onConnectStatusChanged(status: ConnectStatus)
    /**
     * 用户登录成功
     * */
    fun onUserSignIn()
    /**
     * 用户登录失败
     * */
    fun onUserSignOut(error: Error)
}