package com.waytous.anticollision

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import com.waytous.anticollision.databinding.ActivitySplashBinding

class SplashActivity : AppCompatActivity() {

    private lateinit var binding:ActivitySplashBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window.decorView.apply {
            // Hide both the navigation bar and the status bar.
            // SYSTEM_UI_FLAG_FULLSCREEN is only available on Android 4.1 and higher, but as
            // a general rule, you should design your app to hide the status bar whenever you
            // hide the navigation bar.
            systemUiVisibility = View.SYSTEM_UI_FLAG_HIDE_NAVIGATION or View.SYSTEM_UI_FLAG_FULLSCREEN
        }
        binding = ActivitySplashBinding.inflate(layoutInflater)
        setContentView(binding.root)
        "${getString(R.string.text_progress, 26)}%".also { binding.textProgress.text = it }
        binding.loadingProgressBar.progress = 26
        binding.loadingProgressBar.show()
    }

}