package com.waytous.anticollision.ui.view

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.os.Bundle
import android.text.Spannable
import android.text.SpannableString
import android.text.style.ForegroundColorSpan
import android.view.LayoutInflater
import android.view.WindowManager
import androidx.core.view.WindowCompat
import androidx.core.view.WindowInsetsCompat
import com.blankj.utilcode.util.BarUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.DialogStandbySelectBinding

class StandbyDialog(context: Context, themeResId: Int) : Dialog(context, themeResId) {

    private lateinit var binding:DialogStandbySelectBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window?.let { BarUtils.setNavBarVisibility(it,false) }
        window?.setLayout(context.resources.getDimension(R.dimen.dp_560).toInt(),context.resources.getDimension(R.dimen.dp_340).toInt())
        val inflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.dialog_standby_select,null)
        }
        binding = DialogStandbySelectBinding.inflate(inflater)
        setContentView(binding.root)
        binding.dialogStandbyConfirm.setOnClickListener {  }
        binding.dialogStandbyCancel.setOnClickListener {
            dismiss()
        }
        setMessageFontStyle()
    }

    private fun setMessageFontStyle(){
        val spannableString = SpannableString(context.getString(R.string.dialog_standby_message))
        val foregroundColorSpan = ForegroundColorSpan(Color.parseColor("#ff3684f9"))
        spannableString.setSpan(foregroundColorSpan,5,7,Spannable.SPAN_INCLUSIVE_INCLUSIVE)
        binding.dialogMessage.text = spannableString
    }

    override fun show() {
        window?.setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE)
        super.show()
        val controller = window?.let {  WindowCompat.getInsetsController(it,it.decorView) }
        controller?.hide(WindowInsetsCompat.Type.systemBars())
        window?.clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE)
    }

}