package com.waytous.anticollision.tcp

import io.netty.buffer.ByteBuf
import com.waytous.anticollision.utils.Error

interface ConnectListener {

    /**
     * 接收到响应数据
     * @param buf
     * */
    fun onDataReceived(buf: ByteBuf)

    /**
     * 链接服务器成功
     * */
    fun onConnect()

    /**
     * 和服务器断开链接
     * */
    fun onDisconnect(error: Error)

}