package com.waytous.anticollision.utils

import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat

/**
 * 连接状态
 * */
enum class ConnectStatus {
    Disconnected, Connected
}

/**
 * 登录状态
 * */
enum class SignInStatus {
    SignOut, SignIn
}

/**
 * tcp通信错误定义
 * */
enum class Error(val reason:String = "success") {
    NOError,
    IOError("io error"),
    StreamClosed("stream closed"),
    ConnectionRefused("connection refused"),
    Timeout("time out"),
    NotConnected("not connected"),
    UserDisconnected("user disconnected"),
    InvalidParam("invalid param"),
    ServerUnknownError("server unknown error"),
    JT808EncodeError("jt808 codec encode error"),
    JT808DecodeError("jt808 codec decode error")
}

fun AppCompatActivity.checkSelfPermissionCompat(permission: String) =
    ActivityCompat.checkSelfPermission(this, permission)

fun AppCompatActivity.shouldShowRequestPermissionRationaleCompat(permission: String) =
    ActivityCompat.shouldShowRequestPermissionRationale(this, permission)

fun AppCompatActivity.requestPermissionsCompat(permissionsArray: Array<String>,
                                               requestCode: Int) {
    ActivityCompat.requestPermissions(this, permissionsArray, requestCode)
}