package com.waytous.anticollision

import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ColorUtils
import com.waytous.anticollision.databinding.ActivitySplashBinding
import com.waytous.anticollision.ui.MainActivity

class SplashActivity : AppCompatActivity() {

    private lateinit var binding:ActivitySplashBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //设置下布局向上移动状态栏的高度
        BarUtils.setStatusBarColor(this, ColorUtils.getColor(R.color.white))
        //设置隐藏虚拟按键
        BarUtils.setNavBarVisibility(this,false);
        binding = ActivitySplashBinding.inflate(layoutInflater)

        setContentView(binding.root)
        "${getString(R.string.text_progress, 57)}%".also { binding.textProgress.text = it }
        binding.loadingProgressBar.progress = 57
        binding.loadingProgressBar.show()
        binding.loadingProgressBar.postDelayed({
                         startActivity(Intent(this,MainActivity::class.java))
        },2000)
    }

}