package com.waytous.anticollision.utils

/**
 * 连接状态
 * */
enum class ConnectStatus {
    Disconnected, Connected
}

/**
 * 登录状态
 * */
enum class SignInStatus {
    SignOut, SignIn
}

/**
 * tcp通信错误定义
 * */
enum class Error(val reason:String = "success") {
    NOError,
    IOError("io error"),
    StreamClosed("stream closed"),
    ConnectionRefused("connection refused"),
    Timeout("time out"),
    NotConnected("not connected"),
    UserDisconnected("user disconnected"),
    InvalidParam("invalid param"),
    ServerUnknownError("server unknown error"),
    JT808EncodeError("jt808 codec encode error"),
    JT808DecodeError("jt808 codec decode error")
}