package com.waytous.anticollision

import android.app.Application
import com.blankj.utilcode.util.LogUtils
import com.blankj.utilcode.util.SPStaticUtils
import com.blankj.utilcode.util.SPUtils
import com.blankj.utilcode.util.Utils
import kotlin.properties.Delegates

class MyApp: Application() {

    override fun onCreate() {
        super.onCreate()
        instance = this
        Utils.init(this)
        LogUtils.getConfig().globalTag = "Waytous"
        SPStaticUtils.setDefaultSPUtils(SPUtils.getInstance("settings"))
    }

    companion object {
        //情况一：声明可空的属性
        private var instance: MyApp by Delegates.notNull()
        fun instance() = instance
    }
}