package com.waytous.anticollision.repository

import com.blankj.utilcode.util.LogUtils
import com.waytous.anticollision.data.api.MapApiService
import com.waytous.anticollision.utils.BARRICADE_SOURCE
import com.waytous.anticollision.utils.DIGGING_WORK_AREA_SOURCE
import com.waytous.anticollision.utils.DUMP_AREA_SOURCE
import com.waytous.anticollision.utils.ELECTRONIC_FENCE_SOURCE
import com.waytous.anticollision.utils.LANE_NODE_SOURCE
import com.waytous.anticollision.utils.LANE_SOURCE
import com.waytous.anticollision.utils.OBSTACLES_SOURCE
import com.waytous.anticollision.utils.PARK_SPOT_SOURCE
import com.waytous.anticollision.utils.RUNNABLE_AREA_SOURCE
import com.waytous.anticollision.utils.STATIC_OBJECTS_SOURCE
import com.waytous.anticollision.utils.STATION_AREA_SOURCE
import com.waytous.anticollision.utils.WET_AREA_SOURCE
import kotlinx.coroutines.flow.flow
import javax.inject.Inject

class MainRepository@Inject constructor(val mapApiService: MapApiService) {

    fun remoteObstaclesVersion(version:String = "-1") = flow {
        val source = mapApiService.obstaclesVersion(version)?.apply {
            sourceId = OBSTACLES_SOURCE
        }
        LogUtils.d("remoteObstaclesVersion")
        emit(source?:throw Exception("获取到的障碍物图层数据为空!"))
    }

    fun remoteElectronicFenceVersion(version:String = "-1")= flow {
        val source = mapApiService.electronicFenceVersion(version)?.apply {
            sourceId = ELECTRONIC_FENCE_SOURCE
        }
        LogUtils.d("remoteElectronicFenceVersion")
       emit( source?:throw Exception("获取到的电子围栏地图数据为空!"))
    }

    fun remoteWetAreaVersion(version:String = "-1")= flow {
        val source = mapApiService.wetAreaVersion(version)?.apply {
            sourceId = WET_AREA_SOURCE
        }
        LogUtils.d("remoteWetAreaVersion")
        emit(source?:throw Exception("获取到的湿滑区域地图数据为空!"))
    }

    fun remoteLaneNodeVersion(version:String = "-1")= flow {
            val source = mapApiService.laneNodeVersion(version)?.apply {
                sourceId = LANE_NODE_SOURCE
            }
            LogUtils.d("remoteLaneNodeVersion")
            emit(source?:throw Exception("获取到的湿滑区域地图数据为空!"))
        }

    fun remoteLaneVersion(version:String = "-1")= flow {
            val source = mapApiService.laneVersion(version)?.apply {
                sourceId = LANE_SOURCE
            }
            LogUtils.d("remoteLaneVersion")
            emit(source?:throw Exception("获取到的车道图层地图数据为空!"))
        }

    fun remoteRunnableAreaVersion(version:String = "-1")= flow {
            val source = mapApiService.runnableAreaVersion(version)?.apply {
                sourceId = RUNNABLE_AREA_SOURCE
            }
            LogUtils.d("remoteRunnableAreaVersion")
            emit(source?:throw Exception("获取到的可行使区域地图数据为空!"))
        }

    fun remoteDumpAreaVersion(version:String = "-1")= flow {
            val source = mapApiService.dumpAreaVersion(version)?.apply {
                sourceId = DUMP_AREA_SOURCE
            }
            LogUtils.d("remoteDumpAreaVersion")
            emit(source?:throw Exception("获取到的卸载区地图数据为空!"))
        }

    fun remoteDiggingWorkAreaVersion(version:String = "-1")= flow {
            val source = mapApiService.diggingWorkAreaVersion(version)?.apply {
                sourceId = DIGGING_WORK_AREA_SOURCE
            }
            LogUtils.d("remoteDiggingWorkAreaVersion")
            emit(source?:throw Exception("获取到的装载区地图数据为空!"))
        }

    fun remoteBarricadeVersion(version:String = "-1")= flow {
            val source = mapApiService.barricadeVersion(version)?.apply {
                sourceId = BARRICADE_SOURCE
            }
            LogUtils.d("remoteBarricadeVersion")
            emit(source?:throw Exception("获取到的挡墙区域地图数据为空!"))
        }

    fun remoteStationAreaVersion(version:String = "-1")= flow {
            val source = mapApiService.stationAreaVersion(version)?.apply {
                sourceId = STATION_AREA_SOURCE
            }
            LogUtils.d("remoteStationAreaVersion")
            emit(source?:throw Exception("获取到的静态区域地图数据为空!"))
        }

    fun remoteParkSpotVersion(version:String = "-1")= flow {
            val source = mapApiService.parkSpotVersion(version)?.apply {
                sourceId = PARK_SPOT_SOURCE
            }
            LogUtils.d("remoteParkSpotVersion")
            emit(source?:throw Exception("获取到的停车位图层地图数据为空!"))
        }

    fun remoteStaticObjectsVersion(version:String = "-1")= flow {
            val source = mapApiService.staticObjectsVersion(version)?.apply {
                sourceId = STATIC_OBJECTS_SOURCE
            }
            LogUtils.d("remoteStaticObjectsVersion")
            emit(source?:throw Exception("获取到的静态区域地图数据为空!"))
        }
}