package com.waytous.anticollision.ui.home

import android.os.Bundle
import android.text.SpannableString
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import com.blankj.utilcode.util.LogUtils
import com.mapbox.geojson.Point
import com.mapbox.maps.CameraOptions
import com.mapbox.maps.MapView
import com.mapbox.maps.MapboxMap
import com.mapbox.maps.Style
import com.mapbox.maps.extension.observable.eventdata.MapLoadingErrorEventData
import com.mapbox.maps.extension.style.sources.generated.geoJsonSource
import com.mapbox.maps.extension.style.style
import com.mapbox.maps.plugin.Plugin
import com.mapbox.maps.plugin.annotation.annotations
import com.mapbox.maps.plugin.annotation.generated.CircleAnnotationOptions
import com.mapbox.maps.plugin.annotation.generated.createCircleAnnotationManager
import com.mapbox.maps.plugin.delegates.listeners.OnMapLoadErrorListener
import com.mapbox.maps.plugin.logo.LogoPlugin
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentHomeBinding
import com.waytous.anticollision.ui.view.MoreFeaturesPopup
import com.waytous.anticollision.ui.view.WorkStatusEditPopup
import com.waytous.anticollision.utils.setTextSize

class HomeFragment : Fragment() {

    private var _binding: FragmentHomeBinding? = null

    private val binding get() = _binding!!

    private lateinit var mapBox:MapboxMap

    private lateinit var moreFeaturesPopup: MoreFeaturesPopup

    private lateinit var workStatusEditPopup: WorkStatusEditPopup

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val homeViewModel =
            ViewModelProvider(this)[HomeViewModel::class.java]

        _binding = FragmentHomeBinding.inflate(inflater, container, false)
        context?:return binding.root
        workStatusEditPopup = WorkStatusEditPopup(context).also {
            it.setOutSideDismiss(true)
            it.popupGravity = Gravity.TOP or Gravity.CENTER
            it.setBackgroundColor(R.color.color_99000000)
        }
        moreFeaturesPopup = MoreFeaturesPopup(context).also {
            it.setOutSideDismiss(true)
            it.popupGravity = Gravity.TOP or Gravity.CENTER
            it.maskOffsetY = 20
            it.setBackgroundColor(R.color.color_99000000)
        }
        val mapView: MapView = binding.defaultMapLayout.mapView
        val logoPlugin = mapView.getPlugin<LogoPlugin>(Plugin.MAPBOX_LOGO_PLUGIN_ID)
        logoPlugin?.enabled = false
        mapBox = mapView.getMapboxMap().also {
            logoPlugin?.enabled = false
        }
        mapBox.setCamera(
            CameraOptions.Builder()
                .center(
                Point.fromLngLat(
                    LATITUDE,
                    LONGITUDE
                ))
                .zoom(ZOOM).build()
        )
        mapView.getMapboxMap().addOnMapLoadErrorListener(object :OnMapLoadErrorListener{
            override fun onMapLoadError(eventData: MapLoadingErrorEventData) {
                LogUtils.e("OnMapLoadErrorListener:${eventData.message}")
            }

        })
        mapView.addRendererSetupErrorListener {
                error -> LogUtils.e("RendererSetupErrorListener:${error}")
        }
        setTodayCarriedNum(18)
        setTodayIllegallyNum(1)
        binding.workStatusEdit.setOnClickListener {
            workStatusEditPopup.showPopupWindow(binding.defaultCurrentWorkStatusLayout)
        }
        binding.defaultToggleMore.setOnClickListener {
            moreFeaturesPopup.showPopupWindow(binding.defaultToggleMore)
        }
        return binding.root
    }

    private fun setTodayCarriedNum(num:Int){
        val templateString = getString(R.string.today_carried_text, num)
        val spannableString = SpannableString(templateString)
        binding.todayCarried.setTextSize(spannableString, templateString,"今日运载(车)")
    }

    private fun setTodayIllegallyNum(num:Int){
        val templateString = getString(R.string.today_illegally_text, num)
        val spannableString = SpannableString(templateString)
        binding.illegallyNum.setTextSize(spannableString, templateString,"违章/警告(次)")
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

    companion object {
        private const val GEOJSON_SOURCE_ID = "tile"
        private const val LATITUDE = 108.926593
        private const val LONGITUDE = 34.213389
        private const val ZOOM = 14.0
    }
}