package com.waytous.anticollision.ui.statistics

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ScreenUtils
import com.waytous.anticollision.databinding.ActivityDataStatisticsBinding
import com.waytous.anticollision.ui.view.ButtonMorePopup

class DataStatisticsActivity : AppCompatActivity(),View.OnClickListener {

    lateinit var binding: ActivityDataStatisticsBinding

    lateinit var popupMoreFeatures: ButtonMorePopup

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ScreenUtils.setFullScreen(this)
        BarUtils.setNavBarVisibility(this,false)
        binding = ActivityDataStatisticsBinding.inflate(layoutInflater)
        setContentView(binding.root)
        popupMoreFeatures = ButtonMorePopup(this).also {
            it.bindLifecycleOwner(this)
        }
        binding.more.setOnClickListener(this)
        binding.goHome.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when(v){
            binding.more -> popupMoreFeatures.showPopupWindow(binding.more)
            binding.goHome -> finish()
        }
    }
}