package com.waytous.anticollision.ui.health

import android.os.Bundle
import android.view.View
import android.view.View.OnClickListener
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ScreenUtils
import com.waytous.anticollision.databinding.ActivityHealthManagerBinding
import com.waytous.anticollision.ui.view.ButtonMorePopup

class HealthManagerActivity : AppCompatActivity(),OnClickListener {

    lateinit var binding:ActivityHealthManagerBinding

    lateinit var popupMoreFeatures: ButtonMorePopup

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ScreenUtils.setFullScreen(this)
        BarUtils.setNavBarVisibility(this,false)
        binding = ActivityHealthManagerBinding.inflate(layoutInflater)
        setContentView(binding.root)
        popupMoreFeatures = ButtonMorePopup(this).also {
            it.bindLifecycleOwner(this)
        }
        binding.more.setOnClickListener(this)
        binding.goHome.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when(v){
            binding.more -> popupMoreFeatures.showPopupWindow(binding.more)
            binding.goHome -> finish()
        }
    }
}