package com.waytous.anticollision.ui

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Bitmap
import android.view.View
import androidx.appcompat.content.res.AppCompatResources
import com.mapbox.geojson.Point
import com.mapbox.maps.MapView
import com.mapbox.maps.Style
import com.mapbox.maps.ViewAnnotationAnchor
import com.mapbox.maps.extension.style.expressions.dsl.generated.interpolate
import com.mapbox.maps.extension.style.layers.properties.generated.*
import com.mapbox.maps.plugin.LocationPuck2D
import com.mapbox.maps.plugin.annotation.annotations
import com.mapbox.maps.plugin.annotation.generated.PointAnnotation
import com.mapbox.maps.plugin.annotation.generated.PointAnnotationManager
import com.mapbox.maps.plugin.annotation.generated.PointAnnotationOptions
import com.mapbox.maps.plugin.annotation.generated.createPointAnnotationManager
import com.mapbox.maps.plugin.locationcomponent.location
import com.mapbox.maps.viewannotation.ViewAnnotationManager
import com.mapbox.maps.viewannotation.viewAnnotationOptions
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.CurrentVehicleViewAnnotationLayoutBinding
import com.waytous.anticollision.utils.BitmapUtils


/**
 * mapbox及控制组件封装
 * @author male
 * @param context
 * */
class MapBoxLayout(private val context: Context,private val mapView:MapView){


    private var zoomLevel:Double = 14.0

    private lateinit var style: Style

    private lateinit var viewAnnotationManager: ViewAnnotationManager

    private lateinit var pointAnnotationManager: PointAnnotationManager

    private lateinit var pointAnnotation: PointAnnotation

    private lateinit var viewAnnotation: View


    companion object{
        private val scaleLengths = listOf(5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000)
        private const val MINIMUM_ZOOM_LEVEL = 11.0
        private const val MAXIMUM_ZOOM_LEVEL = 26.0
    }
    
    

    private val iconCurrentNormalVehicleBitmap by lazy {
        BitmapUtils.bitmapFromDrawableRes(context,R.drawable.my_vehicle_normal)
    }

    private val iconOtherAlarmVehicleBitmap by lazy {
        BitmapUtils.bitmapFromDrawableRes(context,R.drawable.other_vehicle_normal)
    }

    fun updateTruckLocation(drawable:Int){
        mapView.location.locationPuck = LocationPuck2D(AppCompatResources.getDrawable(context,drawable),scaleExpression = interpolate {
            linear()
            zoom()
            stop {
                literal(MINIMUM_ZOOM_LEVEL)
                literal(0.6)
            }
            stop {
                literal(MAXIMUM_ZOOM_LEVEL)
                literal(1.2)
            }
        }.toJson())
    }

    fun updateRoundTrucks(vararg points:Point){
        points.forEach {

        }
    }

    @SuppressLint("SetTextI18n")
    private fun prepareViewAnnotation() {
        viewAnnotation = viewAnnotationManager.addViewAnnotation(
            resId = R.layout.current_vehicle_view_annotation_layout,
            options = viewAnnotationOptions {
                geometry(Point.fromLngLat(MainViewModel.LONGITUDE,MainViewModel.LATITUDE))
                associatedFeatureId(pointAnnotation.featureIdentifier)
                anchor(ViewAnnotationAnchor.BOTTOM)
                offsetY((pointAnnotation.iconImageBitmap?.height!!).toInt())
            }
        )
        CurrentVehicleViewAnnotationLayoutBinding.bind(viewAnnotation)
    }

    private fun prepareAnnotationMarker(mapView: MapView, iconBitmap: Bitmap) {
        val annotationPlugin = mapView.annotations
        val pointAnnotationOptions: PointAnnotationOptions = PointAnnotationOptions()
            .withPoint(Point.fromLngLat(MainViewModel.LONGITUDE,MainViewModel.LATITUDE))
            .withIconImage(iconBitmap)
            .withIconAnchor(IconAnchor.BOTTOM)
        pointAnnotationManager = annotationPlugin.createPointAnnotationManager()
        pointAnnotation = pointAnnotationManager.create(pointAnnotationOptions)
    }

}