package com.waytous.anticollision.ui.view

import android.content.Context
import android.view.Gravity
import android.view.View
import android.view.View.OnClickListener
import com.waytous.anticollision.R
import razerdp.basepopup.BasePopupWindow

class ButtonReportStatusPopup (val context: Context?) : BasePopupWindow(context),OnClickListener{

    private var delayCauseDialog: DelayCauseDialog

    private var faultCauseDialog: FaultCauseDialog

    private var standbyDialog: StandbyDialog

    init {
        contentView = createPopupById(R.layout.popup_report_status)
        setOutSideDismiss(true)
        popupGravity = Gravity.TOP or Gravity.CENTER
        setBackgroundColor(R.color.color_99000000)
        delayCauseDialog = DelayCauseDialog(context!!,R.style.DialogStyle)
        faultCauseDialog = FaultCauseDialog(context,R.style.DialogStyle)
        standbyDialog = StandbyDialog(context,R.style.DialogStyle)
    }

    override fun onClick(v: View?) {
        when(v?.id) {
            R.id.reportDialogDelay->{
                delayCauseDialog.show()
            }
            R.id.reportDialogFault->{
                faultCauseDialog.show()
            }
            R.id.reportDialogStandby->{
                standbyDialog.show()
            }
        }
    }
}