package com.waytous.anticollision.ui.video

import android.net.Uri
import android.os.Bundle
import android.text.SpannableString
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ScreenUtils
import com.google.android.exoplayer2.ExoPlayer
import com.google.android.exoplayer2.MediaItem
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.ActivityHomeVideoBinding
import com.waytous.anticollision.ui.MainViewModel
import com.waytous.anticollision.ui.view.ButtonMorePopup
import com.waytous.anticollision.ui.view.ButtonReportStatusPopup
import com.waytous.anticollision.ui.view.ButtonWorkStatusPopup
import com.waytous.anticollision.utils.setTextSize
import com.waytous.anticollision.utils.setupMapBox
import java.io.File
import javax.inject.Inject

class HomeVideoActivity : AppCompatActivity(), View.OnClickListener {

    private lateinit var binding: ActivityHomeVideoBinding

    @Inject
    lateinit var mainViewModel: MainViewModel

    lateinit var popupMoreFeatures: ButtonMorePopup

    lateinit var popupWorkStatusEdit: ButtonWorkStatusPopup

    lateinit var popupReportStatus: ButtonReportStatusPopup

    private var player1: ExoPlayer? = null

    private var player2: ExoPlayer? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ScreenUtils.setFullScreen(this)
        BarUtils.setNavBarVisibility(this,false)
        binding = ActivityHomeVideoBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.titleBar.statusBarDriverInfo.visibility = View.VISIBLE
        val templateString = getString(R.string.current_speed, 36)
        val spannableString = SpannableString(templateString)
        binding.speedText.setTextSize(spannableString, templateString)
        initPlayer()
        initPopupWindow()
        binding.more.setOnClickListener(this)
        binding.workStatusEdit.setOnClickListener(this)
        binding.reportStatus.setOnClickListener(this)
        setupMapBox(binding.mapContainer,mainViewModel)
    }

    override fun onClick(v: View?) {
        when (v) {
            binding.more ->{
                popupMoreFeatures.showPopupWindow(binding.more)
            }
            binding.workStatusEdit ->{
                popupWorkStatusEdit.showPopupWindow(binding.workStatusLayout)
            }
            binding.reportStatus->{
                popupReportStatus.showPopupWindow(binding.reportStatus)
            }
        }
    }

    private fun initPopupWindow(){
        popupMoreFeatures = ButtonMorePopup(this).also {
            it.bindLifecycleOwner(this)
        }
        popupWorkStatusEdit = ButtonWorkStatusPopup(this).also {
            it.bindLifecycleOwner(this)
        }
        popupReportStatus = ButtonReportStatusPopup(this).also {
            it.bindLifecycleOwner(this)
        }
    }

    private fun initPlayer() {
        val uri1 = Uri.fromFile(File(filesDir, "飞书20230420-181456.mp4"))
        player1 = ExoPlayer.Builder(this).build().apply {
            setMediaItem(MediaItem.Builder().setUri(uri1).build())
        }
        binding.videoView1.player = player1
        player1?.prepare()
        val uri2 = Uri.fromFile(File(filesDir, "飞书20230420-181512.mp4"))
        player2 = ExoPlayer.Builder(this).build().apply {
            setMediaItem(MediaItem.Builder().setUri(uri2).build())
        }
        binding.videoView2.player = player2
        player2?.prepare()
        player1?.play()
        player2?.play()
    }

    override fun onDestroy() {
        player1?.release()
        player2?.release()
        super.onDestroy()
    }
}