package com.waytous.anticollision.ui.home

import android.os.Bundle
import android.view.View
import android.view.View.OnClickListener
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ScreenUtils
import com.waytous.anticollision.databinding.ActivityHomeBinding
import com.waytous.anticollision.ui.MainViewModel
import com.waytous.anticollision.ui.view.ButtonMorePopup
import com.waytous.anticollision.ui.view.ButtonReportStatusPopup
import com.waytous.anticollision.ui.view.ButtonWorkStatusPopup
import com.waytous.anticollision.utils.setupMapBox
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class HomeActivity : AppCompatActivity(),OnClickListener {

    private lateinit var binding: ActivityHomeBinding

    @Inject
    lateinit var mainViewModel: MainViewModel

    lateinit var popupMoreFeatures: ButtonMorePopup

    lateinit var popupWorkStatusEdit: ButtonWorkStatusPopup

    lateinit var popupReportStatus: ButtonReportStatusPopup

    companion object {
        private val scaleLengths = listOf(
            5,
            10,
            20,
            50,
            100,
            200,
            500,
            1000,
            2000,
            5000,
            10000,
            20000,
            50000,
            100000,
            200000,
            500000,
            1000000,
            2000000
        )
        const val MINIMUM_ZOOM_LEVEL = 11.0
        const val MAXIMUM_ZOOM_LEVEL = 26.0
        const val DEFAULT_ZOOM_LEVEL = 14.0
    }

//    fun addTempAnnotations() {
//        val otherAnnotation = VehicleLocationInfo(
//            "KK-01", 36, 25,
//            Point.fromLngLat(LONGITUDE, LATITUDE), true
//        )
//        updateCurrentVehicleAnnotation(otherAnnotation)
//        val otherAnnotation1 =
//            VehicleLocationInfo("KK-02", 24, 25, Point.fromLngLat(119.76739, 49.37722), true)
//        val otherAnnotation2 =
//            VehicleLocationInfo("KK-03", 36, 20, Point.fromLngLat(119.75694, 49.38632), true)
//        val others = listOf(otherAnnotation1, otherAnnotation2)
//        addOtherVehicleAnnotations(others)
//    }

//    private fun initAnnotationManager() {
//        viewAnnotationManager = mapBinding.mapView.viewAnnotationManager
//        pointAnnotationManager =
//            mapBinding.mapView.annotations.createPointAnnotationManager(
//                AnnotationConfig(TRUCK_PATH_LAYER)
//            )
//    }

//    fun updateCurrentVehicleAnnotation(otherAnnotation: VehicleLocationInfo) {
//        val pointAnnotationOptions: PointAnnotationOptions = PointAnnotationOptions()
//            .withPoint(otherAnnotation.point)
//            .withIconImage(iconCurrentNormalVehicleBitmap!!)
//            .withIconSize(0.25)
//            .withIconAnchor(IconAnchor.BOTTOM)
//            .withDraggable(false)
//        val pointAnnotation = pointAnnotationManager.create(pointAnnotationOptions)
//        pointAnnotation.symbolSortKey = Double.MAX_VALUE
//        val viewAnnotation = viewAnnotationManager.addViewAnnotation(
//            resId = R.layout.current_annotation_layout,
//            options = viewAnnotationOptions {
//                geometry(otherAnnotation.point)
//                associatedFeatureId(pointAnnotation.featureIdentifier)
//                anchor(ViewAnnotationAnchor.BOTTOM)
//                offsetY((pointAnnotation.iconImageBitmap?.height!! * 0.25).toInt())
//                allowOverlap(true)
//            }
//        )
//        val binding = CurrentAnnotationLayoutBinding.bind(viewAnnotation)
//        binding.annotationCurrentVehicleNo.text =
//            getString(R.string.annotation_vehicle_no, "KK-001")
//        binding.annotationCurrentVehicleSpeed.text =
//            getString(R.string.annotation_vehicle_speed, 36)
//    }
//
//    fun addOtherVehicleAnnotations(others: List<VehicleLocationInfo>) {
//        others.forEach { vehicle ->
//            val pointAnnotationOptions: PointAnnotationOptions = PointAnnotationOptions()
//                .withPoint(vehicle.point)
//                .withIconImage(iconOtherAlarmVehicleBitmap!!)
//                .withIconSize(0.25)
//                .withIconAnchor(IconAnchor.BOTTOM)
//                .withDraggable(false)
//            val pointAnnotation = pointAnnotationManager.create(pointAnnotationOptions)
//            pointAnnotation.symbolSortKey = Double.MAX_VALUE
//            val viewAnnotation = viewAnnotationManager.addViewAnnotation(
//                resId = R.layout.other_annotation_layout,
//                options = viewAnnotationOptions {
//                    geometry(vehicle.point)
//                    associatedFeatureId(pointAnnotation.featureIdentifier)
//                    anchor(ViewAnnotationAnchor.BOTTOM)
//                    offsetY((pointAnnotation.iconImageBitmap?.height!! * 0.25).toInt())
//                    allowOverlap(true)
//                }
//            )
//            val binding = OtherAnnotationLayoutBinding.bind(viewAnnotation)
//            binding.annotationOtherVehicleNo.text = getString(R.string.annotation_vehicle_no, vehicle.vehicleNo)
//            binding.annotationOtherVehicleSpeed.text = vehicle.speed.toString()
//            binding.annotationOtherVehicleDistance.text = vehicle.distance.toString()
//        }
//    }
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        ScreenUtils.setFullScreen(this)
        BarUtils.setNavBarVisibility(this,false)
        binding = ActivityHomeBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.titleBar.statusBarDriverInfo.visibility = View.GONE
        initPopupWindow()
        binding.more.setOnClickListener(this)
        binding.workStatusEdit.setOnClickListener(this)
        binding.statusReport.setOnClickListener(this)
        setupMapBox(binding.mapContainer,mainViewModel)
    }

    private fun initPopupWindow(){
        popupMoreFeatures = ButtonMorePopup(this).also {
            it.bindLifecycleOwner(this)
        }
        popupWorkStatusEdit = ButtonWorkStatusPopup(this).also {
            it.bindLifecycleOwner(this)
        }
        popupReportStatus = ButtonReportStatusPopup(this).also {
            it.bindLifecycleOwner(this)
        }
    }

    override fun onClick(v: View?) {
        when (v) {
            binding.more ->{
                popupMoreFeatures.showPopupWindow(binding.more)
            }
            binding.workStatusEdit ->{
                popupWorkStatusEdit.showPopupWindow(binding.workStatusLayout)
            }
            binding.statusReport->{
                popupReportStatus.showPopupWindow(binding.statusReport)
            }
        }
    }

}