package com.waytous.anticollision.config

import com.blankj.utilcode.util.DeviceUtils
import com.blankj.utilcode.util.SPUtils
import io.github.toggery.jt808.messagebody.B0100

/**
 * 设备配置参数
 * */
object DeviceConfig {

    /**
     * 省份ID
     * */
    var province: Int = SPUtils.getInstance().getInt("province", 11)

    /**
     * 城市ID
     * */
    var city: Int = SPUtils.getInstance().getInt("city", 0)

    /**
     * 车牌颜色
     * */
    var plateColor: Int = SPUtils.getInstance().getInt("plateColor", B0100.PLATE_COLOR_YELLOW)

    /**
     * 设备制造商
     * */
    var maker: String = SPUtils.getInstance().getString("maker", DeviceUtils.getManufacturer())

    /**
     * 手机号码
     * */
    var phoneNumber: String = SPUtils.getInstance().getString("phone", "")



    object HostConfig {
        /**
         * 服务器地址
         * */
        var host: String = SPUtils.getInstance().getString("host", "")

        /**
         * 服务器端口
         * */
        var port: Int = SPUtils.getInstance().getInt("port", 0)
    }
}