package com.waytous.anticollision

import android.app.Application
import com.blankj.utilcode.util.CrashUtils
import com.blankj.utilcode.util.LogUtils
import com.blankj.utilcode.util.SPStaticUtils
import com.blankj.utilcode.util.SPUtils
import com.blankj.utilcode.util.Utils
import dagger.hilt.android.HiltAndroidApp

@HiltAndroidApp
class AntiCollisionApp: Application(){
    override fun onCreate() {
        super.onCreate()
        Utils.init(this)
        LogUtils.getConfig().globalTag = "male"
        CrashUtils.init()
        SPStaticUtils.setDefaultSPUtils(SPUtils.getInstance("settings"))
    }

}