package com.waytous.anticollision.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ColorUtils
import com.gyf.immersionbar.ImmersionBar
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //设置下布局向上移动状态栏的高度
        BarUtils.setStatusBarColor(this, ColorUtils.getColor(R.color.status_bg_color))
        //设置隐藏虚拟按键
        BarUtils.setNavBarVisibility(this,false)
        BarUtils.setStatusBarVisibility(this,false)
        supportActionBar?.hide()
        ImmersionBar.with(this)
            .statusBarAlpha(0.0f)
            .statusBarDarkFont(true)
            .fitsSystemWindows(true)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)
    }

}