package com.waytous.anticollision.config

import com.waytous.anticollision.utils.PreferenceDelegate

/**
 * 设置
 * */
object Settings {

    /**
     * 司机姓名
     * */
    var driverName: String = ""
        @Synchronized set

    /**
     * 车牌号
     * */
    var plateNo: String = ""
        @Synchronized set

    /**
     * 设备唯一识别码
     * */
    var deviceId: String by PreferenceDelegate("deviceId", "")

    /**
     * 是否已注册
     * */
    var isRegistered: Boolean by PreferenceDelegate("isRegistered", false)

    /**
     * 设备注册鉴权码
     * */
    var token: String by PreferenceDelegate("token", "")

    /**
     * DWORD 终端心跳发送间隔，单位为秒（s）,默认2分钟
     * */
    var x0001:Long by PreferenceDelegate("x0001", 120)
    /**
     * DWORD 消息应答超时时间，单位为秒（s）
     * */
    var x0002:Long by PreferenceDelegate("x0002", 60)
    /**
     * DWORD TCP 消息重传次数
     * */
    var x0003:Long by PreferenceDelegate("x0003", 3)
    /**
     * STRING 主服务器 APN，无线通信拨号访问点，若网络制式为 CDMA，则该处为 PPP 拨号号码
     * */
    var x0010:String by PreferenceDelegate("x0010", "")
    /**
     * STRING 主服务器无线通信拨号用户名
     * */
    var x0011:String by PreferenceDelegate("x0011", "")
    /**
     * STRING 主服务器无线通信拨号密码
     * */
    var x0012:String by PreferenceDelegate("x0012", "")
    /**
     * STRING 主服务器地址，IP 或域名(2019 版以冒号分割主机和端口，多个服务器使用分号分隔)
     * */
    var x0013:String by PreferenceDelegate("x0013", "")
    /**
     * STRING 备份服务器 APN，无线通信拨号访问点
     * */
    var x0014:String by PreferenceDelegate("x0014", "")
    /**
     * STRING 备份服务器无线通信拨号用户名
     * */
    var x0015:String by PreferenceDelegate("x0015", "")
    /**
     * STRING 备份服务器无线通信拨号密码
     * */
    var x0016:String by PreferenceDelegate("x0016", "")
    /**
     * STRING 备份服务器地址、IP 或域名(2019 版以冒号分割主机和端口，多个服务器使用分号分隔)
     * */
    var x0017:String by PreferenceDelegate("x0017", "")
    /**
     * DWORD 服务器 TCP 端口 // 2019 del
     * */
    var x0018:Long by PreferenceDelegate("x0018", -1)
    /**
     * STRING 道路运输证 IC 卡认证主服务器 IP 地址或域名
     * */
    var x001A:String by PreferenceDelegate("x001A", "")
    /**
     * DWORD 道路运输证 IC 卡认证主服务器 TCP 端口
     * */
    var x001B:Long by PreferenceDelegate("x001B", -1)

}