package com.waytous.anticollision.ui.video

import android.net.Uri
import android.os.Bundle
import android.text.SpannableString
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.widget.AppCompatTextView
import androidx.fragment.app.viewModels
import androidx.navigation.fragment.findNavController
import com.google.android.exoplayer2.ExoPlayer
import com.google.android.exoplayer2.MediaItem
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentVideoHomeBinding
import com.waytous.anticollision.ui.BaseMapFragment
import com.waytous.anticollision.ui.view.MoreFeaturesPopup
import com.waytous.anticollision.ui.view.WorkStatusEditPopup
import com.waytous.anticollision.utils.setTextSize
import java.io.File

class HomeVideoFragment : BaseMapFragment() {

    private lateinit var binding: FragmentVideoHomeBinding

    private var player1: ExoPlayer? = null

    private var player2: ExoPlayer? = null


    companion object {
        fun newInstance() = HomeVideoFragment()

    }

    private val viewModel: VideoHomeViewModel by viewModels()

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = FragmentVideoHomeBinding.inflate(inflater, container, false)
        context ?: return binding.root
        workStatusEditPopup = WorkStatusEditPopup(context).also {
            it.setOutSideDismiss(true)
            it.popupGravity = Gravity.TOP or Gravity.CENTER
            it.setBackgroundColor(R.color.color_99000000)
        }
        moreFeaturesPopup = MoreFeaturesPopup(context).also {pupop->
            pupop.setOutSideDismiss(true)
            pupop.popupGravity = Gravity.TOP or Gravity.CENTER
            pupop.maskOffsetY = 20
            pupop.setBackgroundColor(R.color.color_99000000)
            pupop.contentView.findViewById<AppCompatTextView>(R.id.moreFeatureCollect).setOnClickListener {
                findNavController().navigate(R.id.action_navigation_video_Home_to_collectFragment)
                pupop.dismiss()
            }
        }
        val templateString = getString(R.string.current_speed, 36)
        val spannableString = SpannableString(templateString)
        binding.workStatusEdit.setOnClickListener {
            workStatusEditPopup.showPopupWindow(binding.currentWorkStatusLayout)
        }
        binding.speedText.setTextSize(spannableString, templateString)
        setupMapBox()
        binding.videoMapWrapper.addView(layoutMapBoxBinding.root)
        initPlayer()
        binding.toggleMore.setOnClickListener {
            moreFeaturesPopup.showPopupWindow(it)
        }
        return binding.root
    }

    private fun initPlayer() {
        val uri1 = Uri.fromFile(File(requireActivity().filesDir, "飞书20230420-181456.mp4"))
        player1 = activity?.let {
            ExoPlayer.Builder(it).build().apply {
                setMediaItem(MediaItem.Builder().setUri(uri1).build())
            }
        }
        binding.videoView1.player = player1
        player1?.prepare()
        val uri2 = Uri.fromFile(File(requireActivity().filesDir, "飞书20230420-181512.mp4"))
        player2 = activity?.let {
            ExoPlayer.Builder(it).build().apply {
                setMediaItem(MediaItem.Builder().setUri(uri2).build())
            }
        }
        binding.videoView2.player = player2
        player2?.prepare()
        player1?.play()
        player2?.play()
    }

    override fun onDestroyView() {
        binding.videoMapWrapper.removeView(layoutMapBoxBinding.root)
        player1?.release()
        player2?.release()
        super.onDestroyView()
    }
}