package com.waytous.anticollision.ui.home

import android.os.Bundle
import android.text.SpannableString
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.app.AlertDialog
import androidx.fragment.app.viewModels
import androidx.lifecycle.ViewModelProvider
import androidx.navigation.fragment.findNavController
import com.blankj.utilcode.util.BarUtils
import com.mapbox.maps.MapView
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.DialogFaultCauseSelectBinding
import com.waytous.anticollision.databinding.FragmentNoVideoHomeBinding
import com.waytous.anticollision.repository.MainRepository
import com.waytous.anticollision.ui.BaseMapFragment
import com.waytous.anticollision.ui.MainViewModel
import com.waytous.anticollision.ui.view.MoreFeaturesPopup
import com.waytous.anticollision.ui.view.ReportStatusPopup
import com.waytous.anticollision.ui.view.WorkStatusEditPopup
import com.waytous.anticollision.utils.setTextSize

class HomeNoVideoFragment : BaseMapFragment() {

    private var _binding: FragmentNoVideoHomeBinding? = null

    private val binding get() = _binding!!

    private lateinit var mapView: MapView

    private var count = 0


    private val mapModel: MainViewModel by viewModels {
        MainViewModel.MainViewModelFactory(MainRepository(requireContext()))
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        BarUtils.setNavBarVisibility(requireActivity(),false)
        val homeViewModel =
            ViewModelProvider(this)[HomeViewModel::class.java]
        _binding = FragmentNoVideoHomeBinding.inflate(inflater, container, false)
        context ?: return binding.root
        setupMapBox()
        binding.noVideoMapWrapper.addView(layoutMapBoxBinding.root)
        setTodayCarriedNum(18)
        setTodayIllegallyNum(1)
        binding.workStatusEdit.setOnClickListener {
            workStatusEditPopup.showPopupWindow(binding.defaultCurrentWorkStatusLayout)
        }
        binding.defaultToggleMore.setOnClickListener {
            moreFeaturesPopup.showPopupWindow(binding.defaultToggleMore)
        }
        binding.defaultReportStatus.setOnClickListener {
            reportStatusPopup.showPopupWindow(binding.defaultReportStatus)
        }
        return binding.root
    }
    private fun setTodayCarriedNum(num: Int) {
        val templateString = getString(R.string.today_carried_text, num)
        val spannableString = SpannableString(templateString)
        binding.todayCarried.setTextSize(spannableString, templateString, "今日运载(车)")
    }

    private fun setTodayIllegallyNum(num: Int) {
        val templateString = getString(R.string.today_illegally_text, num)
        val spannableString = SpannableString(templateString)
        binding.illegallyNum.setTextSize(spannableString, templateString, "违章/警告(次)")
    }

    override fun onDestroyView() {
        super.onDestroyView()
        binding.noVideoMapWrapper.removeView(layoutMapBoxBinding.root)
        _binding = null
    }

}