package com.waytous.anticollision.ui.home

import android.os.Bundle
import android.text.SpannableString
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.viewModels
import androidx.lifecycle.*
import com.blankj.utilcode.util.LogUtils
import com.mapbox.maps.MapView
import com.mapbox.maps.MapboxMap
import com.mapbox.maps.plugin.annotation.generated.PointAnnotation
import com.mapbox.maps.plugin.annotation.generated.PointAnnotationManager
import com.mapbox.maps.plugin.attribution.attribution
import com.mapbox.maps.plugin.compass.compass
import com.mapbox.maps.plugin.logo.logo
import com.mapbox.maps.viewannotation.ViewAnnotationManager
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentHomeBinding
import com.waytous.anticollision.repository.MainRepository
import com.waytous.anticollision.ui.BaseFragment
import com.waytous.anticollision.ui.MainViewModel
import com.waytous.anticollision.ui.view.MoreFeaturesPopup
import com.waytous.anticollision.ui.view.WorkStatusEditPopup
import com.waytous.anticollision.utils.setTextSize
import kotlinx.coroutines.launch

class HomeFragment : BaseFragment() {

    private var _binding: FragmentHomeBinding? = null

    private val binding get() = _binding!!

    private lateinit var mapView: MapView

    private lateinit var mapBox:MapboxMap

    private lateinit var viewAnnotationManager: ViewAnnotationManager

    private lateinit var pointAnnotationManager: PointAnnotationManager

    private lateinit var pointAnnotation: PointAnnotation

    private lateinit var moreFeaturesPopup: MoreFeaturesPopup

    private lateinit var workStatusEditPopup: WorkStatusEditPopup

    private val mapModel: MainViewModel by viewModels{
        MainViewModel.MainViewModelFactory(MainRepository(requireContext()))
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val homeViewModel =
            ViewModelProvider(this)[HomeViewModel::class.java]
        _binding = FragmentHomeBinding.inflate(inflater, container, false)
        context?:return binding.root
        workStatusEditPopup = WorkStatusEditPopup(context).also {
            it.setOutSideDismiss(true)
            it.popupGravity = Gravity.TOP or Gravity.CENTER
            it.setBackgroundColor(R.color.color_99000000)
        }
        moreFeaturesPopup = MoreFeaturesPopup(context).also {
            it.setOutSideDismiss(true)
            it.popupGravity = Gravity.TOP or Gravity.CENTER
            it.maskOffsetY = 20
            it.setBackgroundColor(R.color.color_99000000)
        }
        mapView = binding.root.findViewById<MapView?>(R.id.mapView).also {
            it.logo.enabled = false
            it.compass.enabled = false
            it.attribution.enabled = false
        }
        viewAnnotationManager = mapView.viewAnnotationManager
        updateMapBox(mapView)
        mapView.addRendererSetupErrorListener {
                error -> LogUtils.e("RendererSetupErrorListener:${error}")
        }
        setTodayCarriedNum(18)
        setTodayIllegallyNum(1)
        binding.workStatusEdit.setOnClickListener {
            workStatusEditPopup.showPopupWindow(binding.defaultCurrentWorkStatusLayout)
        }
        binding.defaultToggleMore.setOnClickListener {
            moreFeaturesPopup.showPopupWindow(binding.defaultToggleMore)
        }
        viewLifecycleOwner.lifecycleScope.launch {
            repeatOnLifecycle(Lifecycle.State.STARTED){
                mapModel.obstaclesSource().collect{binding.defaultMapLayout.addObstaclesSource(it)}
                mapModel.runnableAreaSource().collect{binding.defaultMapLayout.addRunnableAreaSource(it)}
                mapModel.laneSource().collect{binding.defaultMapLayout.addLaneSource(it)}
                mapModel.laneNodeSource().collect{binding.defaultMapLayout.addLaneNodeSource(it)}
                mapModel.staticObjectsSource().collect{binding.defaultMapLayout.addStaticObjectsSource(it)}
                mapModel.diggingWorkAreaSource().collect{binding.defaultMapLayout.addDiggingWorkAreaSource(it)}
                mapModel.barricadeSource().collect{binding.defaultMapLayout.addBarricadeSource(it)}
                mapModel.stationAreaSource().collect{binding.defaultMapLayout.addStationAreaSource(it)}
                mapModel.parkSpotSource().collect{binding.defaultMapLayout.addParkSpotSource(it)}
                mapModel.electronicFenceSource().collect{binding.defaultMapLayout.addElectronicFenceSource(it)}
                mapModel.wetAreaSource().collect{binding.defaultMapLayout.addWetAreaSource(it)}
                mapModel.dumpAreaSource().collect{binding.defaultMapLayout.addDumpAreaSource(it)}
            }
        }

        return binding.root
    }


    private fun setTodayCarriedNum(num:Int){
        val templateString = getString(R.string.today_carried_text, num)
        val spannableString = SpannableString(templateString)
        binding.todayCarried.setTextSize(spannableString, templateString,"今日运载(车)")
    }

    private fun setTodayIllegallyNum(num:Int){
        val templateString = getString(R.string.today_illegally_text, num)
        val spannableString = SpannableString(templateString)
        binding.illegallyNum.setTextSize(spannableString, templateString,"违章/警告(次)")
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

}