package com.waytous.anticollision.ui.collect

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import com.afollestad.materialdialogs.MaterialDialog
import com.blankj.utilcode.util.LogUtils
import com.google.android.material.tabs.TabLayout
import com.google.android.material.tabs.TabLayout.OnTabSelectedListener
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentCollectBinding

class CollectFragment : Fragment() {

    companion object{
        const val TAB_ITEM_COLLECT  = 0x01
        const val TAB_ITEM_SETTINGS = 0x02
    }

    private var _binding: FragmentCollectBinding? = null

    private val binding get() = _binding!!

    private lateinit var dialogFaultCause:MaterialDialog

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentCollectBinding.inflate(inflater, container, false)
        context?:return binding.root
        initTablayout()
        MaterialDialog(context!!).show {
            setContentView(R.layout.dialog_fault_cause_select)
        }
        return binding.root
    }

    private fun initTablayout(){
        val collectItem = LayoutInflater.from(context).inflate(
            R.layout.fragment_collect_tab_collect,
            null,
            false
        )
        binding.collectTabContent.addView(collectItem)
        val settingsItem = LayoutInflater.from(context).inflate(
            R.layout.fragment_collect_tab_settings,
            null,
            false
        )
        binding.collectRadioGroup.setOnCheckedChangeListener { _, checkedId ->
            binding.collectTabContent.removeAllViews()
            if (checkedId == R.id.collectTabCollect) {
                binding.collectTabContent.addView(collectItem)
            } else {
                binding.collectTabContent.addView(settingsItem)
            }
        }
    }

}