package com.waytous.anticollision.database

import androidx.room.*
import com.waytous.anticollision.bean.MapDataSource

@Dao
interface MapDataDao {

    @Query("SELECT * FROM map_source WHERE sourceId = :sourceId")
    suspend fun findById(sourceId:String):MapDataSource

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertAll(vararg sources: MapDataSource)

    @Delete
    suspend fun deleteSource(source: MapDataSource)

}