package com.waytous.anticollision.ui.view

import android.content.Context
import android.view.Gravity
import androidx.navigation.NavController
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.PopupMoreFeaturesBinding
import razerdp.basepopup.BasePopupWindow
import javax.inject.Inject

class ButtonMorePopup @Inject constructor(context: Context?,val binding: PopupMoreFeaturesBinding) : BasePopupWindow(context) {

    init {
        contentView = binding.root
        setOutSideDismiss(true)
        popupGravity = Gravity.TOP or Gravity.CENTER
        maskOffsetY = 20
        setBackgroundColor(R.color.color_99000000)
    }

    fun navigationTo(navController: NavController){
        binding.moreFeatureCollect.setOnClickListener {
            dismiss()
            navController.navigate(R.id.collectFragment)
        }
    }
}