package com.waytous.anticollision.ui.video

import android.net.Uri
import android.os.Bundle
import android.text.SpannableString
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.fragment.app.viewModels
import com.google.android.exoplayer2.ExoPlayer
import com.google.android.exoplayer2.MediaItem
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentVideoHomeBinding
import com.waytous.anticollision.databinding.LayoutMapBoxBinding
import com.waytous.anticollision.ui.view.ButtonMorePopup
import com.waytous.anticollision.ui.view.ButtonReportStatusPopup
import com.waytous.anticollision.ui.view.ButtonWorkStatusPopup
import com.waytous.anticollision.utils.setTextSize
import dagger.hilt.android.AndroidEntryPoint
import java.io.File
import javax.inject.Inject

@AndroidEntryPoint
class HomeVideoFragment : Fragment() {

    private lateinit var binding: FragmentVideoHomeBinding

    @Inject
    lateinit var mapBoxBinding: LayoutMapBoxBinding
    @Inject
    lateinit var popupMoreFeatures:ButtonMorePopup
    @Inject
    lateinit var popupWorkStatusEdit:ButtonWorkStatusPopup
    @Inject
    lateinit var popupReportStatus: ButtonReportStatusPopup

    private var player1: ExoPlayer? = null

    private var player2: ExoPlayer? = null

    private val viewModel: VideoHomeViewModel by viewModels()

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = FragmentVideoHomeBinding.inflate(inflater, container, false)
        context ?: return binding.root
        val templateString = getString(R.string.current_speed, 36)
        val spannableString = SpannableString(templateString)
        binding.workStatusEdit.setOnClickListener {
            popupWorkStatusEdit.showPopupWindow(binding.currentWorkStatusLayout)
        }
        binding.speedText.setTextSize(spannableString, templateString)
        binding.videoMapWrapper.addView(mapBoxBinding.root)
        initPlayer()
        binding.toggleMore.setOnClickListener {
            popupMoreFeatures.showPopupWindow(it)
        }
        return binding.root
    }

    private fun initPlayer() {
        val uri1 = Uri.fromFile(File(requireActivity().filesDir, "飞书20230420-181456.mp4"))
        player1 = activity?.let {
            ExoPlayer.Builder(it).build().apply {
                setMediaItem(MediaItem.Builder().setUri(uri1).build())
            }
        }
        binding.videoView1.player = player1
        player1?.prepare()
        val uri2 = Uri.fromFile(File(requireActivity().filesDir, "飞书20230420-181512.mp4"))
        player2 = activity?.let {
            ExoPlayer.Builder(it).build().apply {
                setMediaItem(MediaItem.Builder().setUri(uri2).build())
            }
        }
        binding.videoView2.player = player2
        player2?.prepare()
        player1?.play()
        player2?.play()
    }

    override fun onDestroyView() {
        player1?.release()
        player2?.release()
        super.onDestroyView()
    }
}