package com.waytous.anticollision.ui.home

import android.os.Bundle
import android.text.SpannableString
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import com.blankj.utilcode.util.BarUtils
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentNoVideoHomeBinding
import com.waytous.anticollision.databinding.LayoutMapBoxBinding
import com.waytous.anticollision.ui.view.ButtonMorePopup
import com.waytous.anticollision.ui.view.ButtonReportStatusPopup
import com.waytous.anticollision.ui.view.ButtonWorkStatusPopup
import com.waytous.anticollision.utils.setTextSize
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class HomeNoVideoFragment : Fragment() {

    private var _binding: FragmentNoVideoHomeBinding? = null
    private val binding get() = _binding!!

    @Inject
    lateinit var mapBoxBinding:LayoutMapBoxBinding
    @Inject
    lateinit var popupMoreFeatures:ButtonMorePopup
    @Inject
    lateinit var popupWorkStatusEdit:ButtonWorkStatusPopup
    @Inject
    lateinit var popupReportStatus:ButtonReportStatusPopup

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        BarUtils.setNavBarVisibility(requireActivity(),false)
        val homeViewModel =
            ViewModelProvider(this)[HomeViewModel::class.java]
        _binding = FragmentNoVideoHomeBinding.inflate(inflater, container, false)
        context ?: return binding.root
        binding.noVideoMapWrapper.addView(mapBoxBinding.root)
        setTodayCarriedNum(18)
        setTodayIllegallyNum(1)
        binding.workStatusEdit.setOnClickListener {
            popupWorkStatusEdit.showPopupWindow(binding.defaultCurrentWorkStatusLayout)
        }
        binding.defaultToggleMore.setOnClickListener {
            popupMoreFeatures.showPopupWindow(binding.defaultToggleMore)
        }
        binding.defaultReportStatus.setOnClickListener {
            popupReportStatus.showPopupWindow(binding.defaultReportStatus)
        }
        return binding.root
    }
    private fun setTodayCarriedNum(num: Int) {
        val templateString = getString(R.string.today_carried_text, num)
        val spannableString = SpannableString(templateString)
        binding.todayCarried.setTextSize(spannableString, templateString, "今日运载(车)")
    }

    private fun setTodayIllegallyNum(num: Int) {
        val templateString = getString(R.string.today_illegally_text, num)
        val spannableString = SpannableString(templateString)
        binding.illegallyNum.setTextSize(spannableString, templateString, "违章/警告(次)")
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

}