package com.waytous.anticollision.di

import android.content.Context
import android.view.LayoutInflater
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.RadioTabCollectBinding
import com.waytous.anticollision.databinding.RadioTabSettingsBinding
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.components.FragmentComponent
import dagger.hilt.android.qualifiers.ActivityContext
import dagger.hilt.android.scopes.FragmentScoped

@InstallIn(FragmentComponent::class)
@Module
object FragmentViewModule {

    @FragmentScoped
    @Provides
    fun provideRadioTabCollect(@ActivityContext context: Context):RadioTabCollectBinding{
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.radio_tab_collect,null)
        }
        return RadioTabCollectBinding.inflate(layoutInflater,null,false)
    }

    @FragmentScoped
    @Provides
    fun provideRadioTabSettings(@ActivityContext context: Context):RadioTabSettingsBinding{
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.radio_tab_settings,null)
        }
        return RadioTabSettingsBinding.inflate(layoutInflater,null,false)
    }
}