package com.waytous.anticollision.di

import android.content.Context
import android.view.LayoutInflater
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.LayoutMapBoxBinding
import com.waytous.anticollision.databinding.PopupMoreFeaturesBinding
import com.waytous.anticollision.databinding.PopupReportStatusBinding
import com.waytous.anticollision.databinding.PopupWorkStatusEditBinding
import com.waytous.anticollision.ui.view.ButtonMorePopup
import com.waytous.anticollision.ui.view.ButtonReportStatusPopup
import com.waytous.anticollision.ui.view.ButtonWorkStatusPopup
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.components.ActivityComponent
import dagger.hilt.android.qualifiers.ActivityContext
import dagger.hilt.android.scopes.ActivityScoped

@InstallIn(ActivityComponent::class)
@Module
object ActivityViewModule {

    @ActivityScoped
    @Provides
    fun provideMapBoxInflater(@ActivityContext context: Context):LayoutMapBoxBinding{
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.layout_map_box,null)
        }
        return LayoutMapBoxBinding.inflate(layoutInflater,null,false)
    }

    @ActivityScoped
    @Provides
    fun provideButtonMorePopupWindowInflater(@ActivityContext context: Context): PopupMoreFeaturesBinding {
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.popup_more_features,null)
        }
        return PopupMoreFeaturesBinding.inflate(layoutInflater,null,false)
    }

    @ActivityScoped
    @Provides
    fun provideReportStatusPopupWindowInflater(@ActivityContext context: Context): PopupReportStatusBinding {
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.popup_report_status,null)
        }
        return PopupReportStatusBinding.inflate(layoutInflater,null,false)
    }

    @ActivityScoped
    @Provides
    fun provideWorkStatusEditPopupWindowInflater(@ActivityContext context: Context): PopupWorkStatusEditBinding {
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.popup_work_status_edit,null)
        }
        return PopupWorkStatusEditBinding.inflate(layoutInflater,null,false)
    }

    @ActivityScoped
    @Provides
    fun provideButtonMorePopupWindow(@ActivityContext context: Context,binding:PopupMoreFeaturesBinding):ButtonMorePopup{
        return ButtonMorePopup(context,binding)
    }

    @ActivityScoped
    @Provides
    fun provideButtonReportStatusPopupWindow(@ActivityContext context: Context,binding:PopupReportStatusBinding):ButtonReportStatusPopup{
        return ButtonReportStatusPopup(context,binding)
    }

    @ActivityScoped
    @Provides
    fun provideButtonWorkStatusEditPopupWindow(@ActivityContext context: Context,binding:PopupWorkStatusEditBinding):ButtonWorkStatusPopup{
        return ButtonWorkStatusPopup(context,binding)
    }
}