package com.waytous.anticollision.ui.home

import android.os.Bundle
import android.text.SpannableString
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.viewModels
import androidx.lifecycle.ViewModelProvider
import com.blankj.utilcode.util.LogUtils
import com.mapbox.maps.MapView
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.FragmentHomeBinding
import com.waytous.anticollision.repository.MainRepository
import com.waytous.anticollision.ui.BaseFragment
import com.waytous.anticollision.ui.MainViewModel
import com.waytous.anticollision.ui.view.MoreFeaturesPopup
import com.waytous.anticollision.ui.view.WorkStatusEditPopup
import com.waytous.anticollision.utils.setTextSize

class HomeFragment : BaseFragment() {

    private var _binding: FragmentHomeBinding? = null

    private val binding get() = _binding!!

    private lateinit var mapView: MapView

    private var count = 0

    private lateinit var moreFeaturesPopup: MoreFeaturesPopup

    private lateinit var workStatusEditPopup: WorkStatusEditPopup



    private val mapModel: MainViewModel by viewModels {
        MainViewModel.MainViewModelFactory(MainRepository(requireContext()))
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val homeViewModel =
            ViewModelProvider(this)[HomeViewModel::class.java]
        _binding = FragmentHomeBinding.inflate(inflater, container, false)
        context ?: return binding.root
        workStatusEditPopup = WorkStatusEditPopup(context).also {
            it.setOutSideDismiss(true)
            it.popupGravity = Gravity.TOP or Gravity.CENTER
            it.setBackgroundColor(R.color.color_99000000)
        }
        moreFeaturesPopup = MoreFeaturesPopup(context).also {
            it.setOutSideDismiss(true)
            it.popupGravity = Gravity.TOP or Gravity.CENTER
            it.maskOffsetY = 20
            it.setBackgroundColor(R.color.color_99000000)
        }
        LogUtils.d("HomeFragment.onCreateView")
        setupMapBox()
        binding.defaultMapLayout.addView(layoutMapBoxBinding.root)
        setTodayCarriedNum(18)
        setTodayIllegallyNum(1)
        binding.workStatusEdit.setOnClickListener {
            workStatusEditPopup.showPopupWindow(binding.defaultCurrentWorkStatusLayout)
        }
        binding.defaultToggleMore.setOnClickListener {
            moreFeaturesPopup.showPopupWindow(binding.defaultToggleMore)
        }
        return binding.root
    }

    private fun setTodayCarriedNum(num: Int) {
        val templateString = getString(R.string.today_carried_text, num)
        val spannableString = SpannableString(templateString)
        binding.todayCarried.setTextSize(spannableString, templateString, "今日运载(车)")
    }

    private fun setTodayIllegallyNum(num: Int) {
        val templateString = getString(R.string.today_illegally_text, num)
        val spannableString = SpannableString(templateString)
        binding.illegallyNum.setTextSize(spannableString, templateString, "违章/警告(次)")
    }

    override fun onDestroyView() {
        super.onDestroyView()
        binding.defaultMapLayout.removeView(layoutMapBoxBinding.root)
        _binding = null
    }

}