package com.waytous.anticollision.ui.home

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import com.mapbox.geojson.Point
import com.mapbox.maps.CameraOptions
import com.mapbox.maps.MapView
import com.mapbox.maps.Style
import com.mapbox.maps.extension.style.layers.generated.lineLayer
import com.mapbox.maps.extension.style.layers.properties.generated.LineCap
import com.mapbox.maps.extension.style.layers.properties.generated.LineJoin
import com.mapbox.maps.extension.style.sources.TileSet
import com.mapbox.maps.extension.style.sources.generated.geoJsonSource
import com.mapbox.maps.extension.style.style
import com.waytous.anticollision.databinding.FragmentHomeBinding

class HomeFragment : Fragment() {

    private var _binding: FragmentHomeBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val homeViewModel =
            ViewModelProvider(this)[HomeViewModel::class.java]

        _binding = FragmentHomeBinding.inflate(inflater, container, false)
        val root: View = binding.root
        val mapView: MapView = binding.mapView
//        val mapView = MapView(this.context!!)
        mapView.getMapboxMap().setCamera(
            CameraOptions.Builder()
//                .center(
//                Point.fromLngLat(
//                    LATITUDE,
//                    LONGITUDE
//                ))
                .zoom(ZOOM).build()
        )
        mapView.getMapboxMap().loadStyle(style(Style.OUTDOORS){
            +geoJsonSource(GEOJSON_SOURCE_ID)
            {
                url("asset://multiple_geometry_example.geojson")
            }
//            +lineLayer("linelayer", GEOJSON_SOURCE_ID) {
//                lineCap(LineCap.ROUND)
//                lineJoin(LineJoin.ROUND)
//                lineOpacity(0.7)
//                lineWidth(8.0)
//                lineColor("#888")
//            }
        })
        return root
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

    companion object {
        private const val GEOJSON_SOURCE_ID = "geo-json"
        private const val LATITUDE = -77.0911931991577
        private const val LONGITUDE = 38.95653886174238
        private const val ZOOM = 14.0
    }
}